
/**
 ******************************************************************************
 *
 * @file        UserEvent.h
 * @brief       User event routine headfile.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef __USEREVENT_H 
#define __USEREVENT_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "Common.h"
#include "RingBuffer.h"
#include "LCD.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
enum UIEvent{
    Dummy,
    EC11_KEY_Push,
    EC11_KEY_Pop,
    EC11_LEFTROTATE,
    EC11_RIGHTROTATE,
    ADCKEY_KEY0_Push,
    ADCKEY_KEY1_Push,
    ADCKEY_KEY2_Push,
    ADCKEY_KEY3_Push,
    ADCKEY_KEY4_Push,
    ADCKEY_KEY5_Push,
    ADCKEY_KEY6_Push,
    ADCKEY_KEY7_Push,
    ADCKEY_KEY8_Push,
    ADCKEY_KEY9_Push,
    ADCKEY_KEY10_Push,
    ADCKEY_KEY11_Push,
    ADCKEY_KEY12_Push,
    ADCKEY_KEY_Pop,
};

//typedef struct{
//    __IO uint8_t RTCEvent;
//    __IO uint8_t PushButtonEvent;       // 0:No event occurred, 1:Event happened
//    __IO uint8_t PopButtonEvent;        // 0:No event occurred, 1:Event happened
//    __IO uint8_t QeiEc11Event;          // 0:No event occurred, 1:Event happened
//    __IO  int8_t QeiEc11Value;          // 0 to 127;
//}UserEvent_HandleTypedef;

typedef struct{
    //__IO uint8_t Layer;                 // 0 ~ 255
    __IO uint8_t Menu;                  // 0 ~ 255
    __IO uint8_t Select;                // 0 ~ 255
    __IO uint8_t Option;                // 0 ~ 255

//    __IO uint8_t L1_Seletc ;           // Setting / Demo / RGBLED / ARGB / LCDDisplay / Sound / Communication

//    __IO uint8_t L2_Seletc ;           // PWM / Breathing / Blinking / Stop
//                                            // Pattern 0 / 1 / 2 / 3 / 4
//                                            // Feature / Geometic / Font / Logo
//                                            // Play / Volume
//                                            // BLE UART / USB Multimedia
//                                            // Back / Idle Time / BLE / Update(DFU)

//    __IO uint8_t L3_Seletc ;           // PWM / Breathing / Blinking / Stop

    __IO uint8_t SetIdleTime;           // 0 Disable / 3Sec / 5Sec / 10Sec(default) / 15Sec / 20Sec / 25Sec / 30Sec / 1Min / 2Min / 3Min / 5Min / 10 Min / 15Min / 20Min / 25Min / 30Min
    __IO uint8_t SetBLE;                // Disable / Enable
    __IO uint8_t SetWIFI;               // Disable / Enable
    __IO uint8_t SetTempture;           // I2C DS1621 / ADC LM35DZ
    __IO uint8_t SetUpdate;             // Disable / Enable
    __IO uint8_t SoundSelect;            // None, Music 1, Music2, Music3, Music4, Music5
    __IO uint8_t SoundPlayStop;         // None, Music 1, Music2, Music3, Music4, Music5
    __IO uint8_t SoundVolume;           // None, 1, 2, 3, 4
    __IO uint8_t LCDPicture;            // None, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11
    __IO uint8_t LEDPWMSpeed;           // None, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11
    __IO uint8_t LEDBreathingSpeed;     // 50ms, 100ms, 200ms, 300ms, 500ms, 1s, 2s, 3s, 5s, 10s, 15s, 20s duty 50%
    __IO uint8_t LEDBLinkingSpeed;      // 50ms, 100ms, 200ms, 300ms, 500ms, 1s, 2s, 3s, 5s, 10s, 15s, 20s duty 50%
}UEvent_HandleTypedef;

/* Private define ------------------------------------------------------------*/
#define BLE_RETARGET_MAX_SIZE 200    // BLR rxBuf/txBuf data size

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void UserEvent_Initial(void);
void UserEvent_Decode(UEvent_HandleTypedef *UEvent);

/* Exported variables --------------------------------------------------------*/
extern RingBufferU8 gEventQueue ;
extern Display_HandleTypeDef LCD1st;
extern Display_HandleTypeDef LCD2nd;

/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
//From BLE_Retarget.c
extern uint8_t BleRxBuf[BLE_RETARGET_MAX_SIZE - 40]; 
extern uint8_t BleTxBuf[BLE_RETARGET_MAX_SIZE];
extern volatile uint8_t BleRxBufInCount;
extern volatile uint8_t BleRxBufOutCount;
extern volatile uint8_t BleTxBufInCount;
extern volatile uint8_t BleTxBufOutCount;


#ifdef __cplusplus
}
#endif

#endif


